C	program vmt
C	3x period vmt and speeds read from file; bins are calculated for each period
C**** 
C	and then written to M6 speed definition files
	Dimension am(1),pm(1),op(22),vmt(24),vmtfrac(24),speed(2,3)
	dimension spdbin(14),binfrac(3,14),vmtarr(7,5,3),spdarr(7,5,3)
	dimension facvmt(4,3),ppvmt(3),facfrac(4,3)
	Character*40 fnam,ayr(7)
	Character*15 farea(5)
	Character*20 frdcls(7)
	character*3 m6fcdef(7),area(5),rdcls(7)
	data area/'cbd','cfr','res','obd','rur'/
C	this is the order of the fun classes in the text files
	data farea/'CBD','CBD Fringe','Residential','Outlying BD',
     x	'Rural'/
	data m6fcdef/'fwy','fwy','art','art','art','loc','rmp'/
        data rdcls/'fwy','exy','pra','mia','col','loc','rmp'/
	data spdbin/2.5,5.,10.,15.,20.,25.,30.,35.,40.,45.,50.,55.,60.,65/
	data am/1.0/	!all am vmt in 0700-0800 hour
	data pm/1.0/	!all pm vmt in 1700-1800 hour
	data op/.0617,.0729,.0496,.0551,.0663,.0615,.06,.0643,.0904,.112,
     x  .0801,.0501,.0432,.0385,.0217,.0142,.0117,.0069,.0057,.0054
     x	,.01,.0177/
C analysis years as follows based on PPACG 2025 Plan
        data ayr/'1990','2000','2005','2007','2010','2015','2025'/
	do iyr = 5,5
	write(fnam,1)ayr(iyr)
	print *,fnam
1	format(a4,'\tdm.txt')
	open(3,file=fnam)
	write(fnam,8)ayr(iyr)
	open(8,file=fnam)
C Format for Colorado Springs files: 5 columns, 42 lines
C (format from Ken's spreadsheets)
C lines 1-7 AM peak VMT, 8-14 AM peak speeds
C lines 15-21 PM peak VMT, 22-28 PM peak speeds
C lines 29-36 OP peak VMT, 37-42 OP peak speeds
C COL 1: cbd, COL 2: cbd fringe, COL 3: Res., COL 4: OBD, COL 5: Rural
C Row 1 - 7; Freeway, Expressway, Pr. Arterial, M. Arterial, Coll, Local, Ramp
	gtot = 0.0
	do ip = 1,3
	    read(3,*)((vmtarr(ifc,ia,ip),ia=1,5),ifc=1,7)
    	    read(3,*)((spdarr(ifc,ia,ip),ia=1,5),ifc=1,7)
	end do
C**********
C processing for hour vmt files
C**********
	do ia = 1,5		! loop through the five area types
C zero out accumulating arrays
	    do ip = 1,3
	  	ppvmt(ip) = 0	!zero the pp vmt total increment variable
	  	speed(1,ip) = 0	!zero the freeway/expressway incr. variable
	  	speed(2,ip) = 0 !zero the arterial increment variable
	  	do ifc = 1,4
	  	    facvmt(ifc,ip) = 0
	  	end do
	    end do
C aggregate the vmt by facility for the VMT BY FACILITY command
	  do ip = 1,3
	     facvmt(1,ip) = facvmt(1,ip) + vmtarr(1,ia,ip) !freeways
     x			+ vmtarr(2,ia,ip)
	     facvmt(2,ip) = facvmt(2,ip) + vmtarr(3,ia,ip) !arterials
     x			+ vmtarr(4,ia,ip)+ vmtarr(5,ia,ip)
	     facvmt(3,ip) = facvmt(3,ip) + vmtarr(6,ia,ip) !locals
	     facvmt(4,ip) = facvmt(4,ip) + vmtarr(7,ia,ip) !ramps
	     do ifc = 1,7
	       	ppvmt(ip) = ppvmt(ip) + vmtarr(ifc,ia,ip)
	     end do
	  end do
C allocate the 3 peak periods to the appropriate hours
	  if (ppvmt(1).gt.0) then
	     vmt(1) = ppvmt(3) * op(1)			!op hr 1 (hr 06)
	     vmt(2)= ppvmt(1)	! all of am VMT in hour 2 (hrs 07-08)
	     vmt(12) = ppvmt(2)	! all pm VMT in hour 11 (hrs17-18)
	     do ihr = 3,11				!op 3-13 (hrs 09-17)
		vmt(ihr) = ppvmt(3) * op(ihr-1)
	     end do
	     do ihr = 13,24				!op 13-24 (hrs 18-05)
		vmt(ihr) = ppvmt(3) * op(ihr-2)
	     end do
	     vmtot = ppvmt(1) + ppvmt(2) + ppvmt(3)
	     do ihr = 1,24
	        vmtfrac(ihr) = vmt(ihr)/vmtot
	     end do
	     write(fnam,5)ayr(iyr),area(ia)
 	     close(2)
 		print *,fnam
 		open(2,file=fnam)
C write file header
		write(2,6)
C write VMT by hour fractions
		write(2,4)(vmtfrac(ihr),ihr=1,24)
		gtot = gtot + vmtot
C******************************************************************
C speed bin calculations follow
C******************************************************************
	write(fnam,3)ayr(iyr),area(ia)
 	close(1)
 	open(1,file=fnam)
C write file header
	write(1,2)
C vmt weight the speeds across for the freeway and arterial facility types
	do ip = 1,3
	    do ifc = 1,2
	        speed(1,ip) = speed(1,ip) + 
     x	 	    (spdarr(ifc,ia,ip)*vmtarr(ifc,ia,ip))/facvmt(1,ip)
     	    end do
	    do ifc = 3,5
	        speed(2,ip) = speed(2,ip) + 
     x		    (spdarr(ifc,ia,ip)*vmtarr(ifc,ia,ip))/facvmt(2,ip)
     	    end do
C calculate the facility type vmt fractions here... 
     	    do ifc=1,4
     	    	facfrac(ifc,ip) = facvmt(ifc,ip)/ppvmt(ip)
     	    end do
     	end do
C calculate the 'bin' fractions for the freeway/exwy and arterials
	do iclass = 1,2
	do ip = 1,3
C zero out the bin fractions
	  do i = 1,14
	    binfrac(ip,i) = 0
	  end do
C find the bin levels for given speed
C 1. speed must be 65 mph or less for M6; 
C 2. If speed = 0, i.e., CBD freeway, assign speed to 65 mph, VMT BY FACILITY command
C    will remove freeway class contribution from emission factors ('freeway' fraction 
C    for all veh. types will be = 0 in the cbd.def files)
	  if((speed(iclass,ip).gt. 65.).or.(speed(iclass,ip).eq.0)) 
     x		speed(iclass,ip) = 65.
	  do i = 1,14
	    if (spdbin(i).ge.speed(iclass,ip)) go to 11
	  end do
 11	  xll = spdbin(i-1)
 	  xul = spdbin(i)
 	  binfrac(ip,i-1) = (speed(iclass,ip) - xul) / (xll - xul)
 	  binfrac(ip,i) = 1 - binfrac(ip,i-1) 
 	end do	!end for period loop
C
C write speeds to file
C 6 am - off peak speed
	i = 1
  	write(1,9)iclass,i,(binfrac(3,k),k=1,14)   
C 7-8 am  peak speeds
 	do i = 2,2
 	     write(1,9)iclass,i,(binfrac(1,k),k=1,14)     
 	end do
C 9 am - 3 pm off peak speeds
 	do i = 3,11
 	     write(1,9)iclass,i,(binfrac(3,k),k=1,14)    
 	end do
C 5-6 pm pm peak speeds 	
 	do i = 12,12
 	 	write(1,9)iclass,i,(binfrac(2,k),k=1,14)
 	end do
C 7 pm - 5 am off peak speeds
 	do i = 13,24
 	       write(1,9)iclass,i,(binfrac(3,k),k=1,14)
 	end do 		
 	end do		! end do for speed file facility class processing
C write the VMT BY FACILITY files
     	close(2)
 	write(fnam,18)ayr(iyr),area(ia)
 	open(2,file=fnam)
 	write(2,17)
 	do ivt = 1,28
c op = first hour (0600-0700)
 	    write(2,19)ivt,(facfrac(ifc,3),ifc=1,4)
C am peak = 2nd hour (0700-0800)
 	    write(2,20)(facfrac(ifc,1),ifc=1,4)
C op = 3-11 hour (0800-1700)
	    do k = 1,9
	        write(2,20)(facfrac(ifc,3),ifc=1,4)
	    end do
C pm peak hour 12 (1700-1800)
	    write(2,20)(facfrac(ifc,2),ifc=1,4)
C op = 1800-0600 hours
	    do k = 1,12
	        write(2,20)(facfrac(ifc,3),ifc=1,4)
	    end do
 	end do
 18	format(a4,'\facvmt\',1a3,'.def')
 17	format('VMT BY FACILITY')
 19	FORMAT(I2,F8.3,3F10.3)
 20	format((4f10.3))
C**********************
C write a scenario for this vmt/speed file record
C
C write scenario header record
	write(8,21)farea(ia),ayr(iyr)
 21	FORMAT('SCENARIO REC       : Colorado Springs',2X,A15,A4)
C write calendar year record
 	WRITE(8,22)ayr(iyr)
 22	format('CALENDAR YEAR      : ',a4)
C write altitude record
	write(8,23)
 23	format('ALTITUDE           : 2')
C write speed vmt record 
	write(8,24)area(ia)
C
 24	format('SPEED VMT          : speed\',a3,'.def')
C write vmt by hour file
	write(8,25)area(ia)
 25	format('VMT BY HOUR        : vmt\',a3,'.def')
C write vmt by facility record
	write(8,26)area(ia)
 26	format('VMT BY FACILITY    : facvmt\',a3,'.def')
 	write(8,27)
 27	format(a)
 	end if 		!enf for conditional on vmt/speed > 0
 	end do 		!end for area type processing
 	print *,' vmt totals: ',gtot
 	end do 	!end for the analysis years
 9	format(i1,x,i2,14f7.4)
 4	format(4x,6f8.4)
 7	format(9f5.1)
 5	format(a4,'\vmt\',a3,'.def')
 3	format(a4,'\speed\',a3,'.def')
 8	format(a4,'\m6scen.txt')
 6	format('VMT BY HOUR')
 2	format('SPEED VMT')
 14	format(a4,2x,2a3,2x,25f8.4)
  	end